/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.lifecycle;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.el.ELResolver;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.lifecycle.AbstractLifeCycle;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.web.context.WebContextsService;
import org.apache.webbeans.web.util.ServletCompatibilityUtil;

public final class WebContainerLifecycle
extends AbstractLifeCycle {
    private ScheduledExecutorService service = null;

    public WebContainerLifecycle() {
        super(null);
        this.logger = WebBeansLoggerFacade.getLogger(WebContainerLifecycle.class);
    }

    public WebContainerLifecycle(WebBeansContext webBeansContext) {
        super(null, webBeansContext);
        this.logger = WebBeansLoggerFacade.getLogger(WebContainerLifecycle.class);
    }

    public void startApplication(Object startupObject) {
        ServletContext servletContext = this.getServletContext(startupObject);
        super.startApplication((Object)servletContext);
    }

    public void stopApplication(Object endObject) {
        ServletContext servletContext = this.getServletContext(endObject);
        super.stopApplication((Object)servletContext);
    }

    protected void afterStartApplication(final Object startupObject) {
        String strDelay = this.getWebBeansContext().getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.conversation.Conversation.periodicDelay", "150000");
        long delay = Long.parseLong(strDelay);
        this.service = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "OwbConversationCleaner-" + ServletCompatibilityUtil.getServletInfo((ServletContext)startupObject));
                t.setDaemon(true);
                return t;
            }
        });
        this.service.scheduleWithFixedDelay(new ConversationCleaner(), delay, delay, TimeUnit.MILLISECONDS);
        ELAdaptor elAdaptor = (ELAdaptor)this.getWebBeansContext().getService(ELAdaptor.class);
        ELResolver resolver = elAdaptor.getOwbELResolver();
        if (this.getWebBeansContext().getOpenWebBeansConfiguration().isJspApplication()) {
            this.logger.log(Level.FINE, "Application is configured as JSP. Adding EL Resolver.");
            JspFactory factory = JspFactory.getDefaultFactory();
            if (factory != null) {
                JspApplicationContext applicationCtx = factory.getJspApplicationContext((ServletContext)startupObject);
                applicationCtx.addELResolver(resolver);
            } else {
                this.logger.log(Level.FINE, "Default JSPFactroy instance has not found");
            }
        }
        ServletContext servletContext = (ServletContext)startupObject;
        servletContext.setAttribute(BeanManager.class.getName(), (Object)this.getBeanManager());
    }

    protected void beforeStartApplication(Object startupObject) {
        this.scannerService.init(startupObject);
    }

    protected void beforeStopApplication(Object stopObject) {
        if (this.service != null) {
            this.service.shutdownNow();
        }
    }

    protected void afterStopApplication(Object stopObject) {
        ServletContext servletContext = stopObject instanceof ServletContext ? (ServletContext)stopObject : this.getServletContext(stopObject);
        ResourceInjectionService injectionServices = (ResourceInjectionService)this.getWebBeansContext().getService(ResourceInjectionService.class);
        if (injectionServices != null) {
            injectionServices.clear();
        }
        this.cleanupShutdownThreadLocals();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "INFO_0002", ServletCompatibilityUtil.getServletInfo(servletContext));
        }
    }

    private void cleanupShutdownThreadLocals() {
        WebContextsService.removeThreadLocals();
    }

    private ServletContext getServletContext(Object object) {
        if (object != null) {
            if (object instanceof ServletContextEvent) {
                object = ((ServletContextEvent)object).getServletContext();
                return (ServletContext)object;
            }
            throw new WebBeansException(WebBeansLoggerFacade.getTokenString((String)"EXCEPT_0018"));
        }
        throw new IllegalArgumentException("ServletContextEvent object but found null");
    }

    private static class ConversationCleaner
    implements Runnable {
        @Override
        public void run() {
            WebBeansContext.getInstance().getConversationManager().destroyWithRespectToTimout();
        }
    }
}

