/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.inject.spi;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionTarget;

public class Unmanaged<T> {
    private BeanManager beanManager;
    private InjectionTarget<T> injectionTarget;

    public Unmanaged(Class<T> clazz) {
        this(CDI.current().getBeanManager(), clazz);
    }

    public Unmanaged(BeanManager beanManager, Class<T> clazz) {
        this.beanManager = beanManager;
        AnnotatedType<T> annotatedType = beanManager.createAnnotatedType(clazz);
        this.injectionTarget = beanManager.createInjectionTarget(annotatedType);
    }

    public UnmanagedInstance<T> newInstance() {
        return new UnmanagedInstance(this.beanManager, this.injectionTarget);
    }

    public static class UnmanagedInstance<T> {
        private BeanManager beanManager;
        private InjectionTarget<T> injectionTarget;
        private CreationalContext<T> creationalContext;
        private T instance;
        private boolean injected = false;
        private boolean disposed = false;

        private UnmanagedInstance(BeanManager beanManager, InjectionTarget<T> injectionTarget) {
            this.injectionTarget = injectionTarget;
            this.beanManager = beanManager;
        }

        public UnmanagedInstance<T> produce() {
            if (this.creationalContext != null) {
                throw new IllegalStateException("UnmanagedInstance is already produced");
            }
            if (this.disposed) {
                throw new IllegalStateException("UnmanagedInstance is already disposed");
            }
            this.creationalContext = this.beanManager.createCreationalContext(null);
            this.instance = this.injectionTarget.produce(this.creationalContext);
            return this;
        }

        public UnmanagedInstance<T> inject() {
            this.basicCheck();
            if (this.injected) {
                throw new IllegalStateException("UnmanagedInstance is already injected");
            }
            this.injectionTarget.inject(this.instance, this.creationalContext);
            this.injected = true;
            return this;
        }

        public UnmanagedInstance<T> postConstruct() {
            this.basicCheck();
            this.injectionTarget.postConstruct(this.instance);
            return this;
        }

        public T get() {
            this.basicCheck();
            return this.instance;
        }

        public UnmanagedInstance<T> preDestroy() {
            this.basicCheck();
            this.injectionTarget.preDestroy(this.instance);
            return this;
        }

        public UnmanagedInstance<T> dispose() {
            this.basicCheck();
            this.injectionTarget.dispose(this.instance);
            this.creationalContext.release();
            return this;
        }

        private void basicCheck() {
            if (this.creationalContext == null) {
                throw new IllegalStateException("UnmanagedInstance is not yet initialized. Invoke #produce() first!");
            }
            if (this.disposed) {
                throw new IllegalStateException("UnmanagedInstance is already disposed");
            }
        }
    }
}

