/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.sysml.parser;

public class ParameterExpression 
{
	
	
	private Expression 	_expr;
	private String 		_name;

	public ParameterExpression(String name, Expression val){
		_name 		= name;
		_expr 		= val;
	}
	
	public String getName(){
		return _name;
	}
	
	public Expression getExpr(){
		return _expr;
	}
	
	public void setName(String name){
		_name = name;
	}
	
	public void setExpr(Expression expr){
		_expr = expr;
	}
	
	@Override
	public String toString(){
		return _name + "=" + _expr;
	}
	
}
