/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class WeightedSigmoid
extends Lop {
    public static final String OPCODE = "mapwsigmoid";
    public static final String OPCODE_CP = "wsigmoid";
    private int _numThreads = 1;
    private WSigmoidType _wsigmoidType = null;

    public WeightedSigmoid(Lop input1, Lop input2, Lop input3, Types.DataType dt, Types.ValueType vt, WSigmoidType wt, Types.ExecType et) {
        super(Lop.Type.WeightedSigmoid, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        this._wsigmoidType = wt;
        this.setupLopProperties(et);
    }

    @Override
    public String toString() {
        return "Operation = WeightedSigmoid";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        if (this.getExecType() == Types.ExecType.CP) {
            sb.append(OPCODE_CP);
        } else {
            sb.append(OPCODE);
        }
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input3));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._wsigmoidType);
        if (this.getExecType() == Types.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }

    public static enum WSigmoidType {
        BASIC,
        LOG,
        MINUS,
        LOG_MINUS;

    }
}

