/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetByte;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class OffsetByteNZ
extends AOffsetByte {
    private static final long serialVersionUID = -4716104973912291890L;

    protected OffsetByteNZ(byte[] offsets, int offsetToFirst, int offsetToLast) {
        super(offsets, offsetToFirst, offsetToLast);
        if (CompressedMatrixBlock.debug) {
            this.toString();
        }
    }

    @Override
    public AIterator getIterator() {
        return new IterateByteOffsetNoZero();
    }

    @Override
    protected AIterator getIteratorFromIndexOff(int row, int dataIndex, int offIdx) {
        return new IterateByteOffsetNoZero(dataIndex, row);
    }

    @Override
    public AOffsetIterator getOffsetIterator() {
        return new OffsetByteIteratorNoZero();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        byte[] its = new byte[13];
        its[0] = (byte)OffsetFactory.OFF_TYPE_SPECIALIZATIONS.BYTENZ.ordinal();
        IOUtilFunctions.intToBa(this.offsetToFirst, its, 1);
        IOUtilFunctions.intToBa(this.offsets.length, its, 5);
        IOUtilFunctions.intToBa(this.offsetToLast, its, 9);
        out.write(its);
        out.write(this.offsets);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 13 + this.offsets.length;
    }

    @Override
    public int getSize() {
        return this.offsets.length + 1;
    }

    @Override
    public long getInMemorySize() {
        return OffsetByteNZ.estimateInMemorySize(this.offsets.length);
    }

    public static long estimateInMemorySize(int nOffs) {
        long size = 32L;
        size = (long)((double)size + MemoryEstimates.byteArrayCost(nOffs));
        return size;
    }

    public static AOffsetByte readFields(DataInput in) throws IOException {
        int offsetToFirst = in.readInt();
        int offsetsLength = in.readInt();
        int offsetToLast = in.readInt();
        byte[] offsets = new byte[offsetsLength];
        in.readFully(offsets);
        return new OffsetByteNZ(offsets, offsetToFirst, offsetToLast);
    }

    @Override
    public AOffset.OffsetSliceInfo slice(int lowOff, int highOff, int lowValue, int highValue, int low, int high) {
        byte[] newOffsets = Arrays.copyOfRange(this.offsets, lowOff, highOff);
        OffsetByteNZ off = new OffsetByteNZ(newOffsets, lowValue, highValue);
        return new AOffset.OffsetSliceInfo(low, high + 1, off);
    }

    @Override
    public AOffset moveIndex(int m) {
        return new OffsetByteNZ(this.offsets, this.offsetToFirst - m, this.offsetToLast - m);
    }

    private class OffsetByteIteratorNoZero
    extends AOffsetIterator {
        protected int index;

        private OffsetByteIteratorNoZero() {
            super(OffsetByteNZ.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            return this.offset += OffsetByteNZ.this.offsets[this.index++] & 0xFF;
        }
    }

    private class IterateByteOffsetNoZero
    extends AIterator {
        protected int index;

        private IterateByteOffsetNoZero() {
            super(OffsetByteNZ.this.offsetToFirst);
        }

        private IterateByteOffsetNoZero(int index, int offset) {
            super(offset);
            this.index = index;
        }

        @Override
        public int next() {
            byte v = OffsetByteNZ.this.offsets[this.index];
            this.offset += v & 0xFF;
            ++this.index;
            return this.offset;
        }

        @Override
        public int skipTo(int idx) {
            while (this.offset < idx && this.index < OffsetByteNZ.this.offsets.length) {
                this.next();
            }
            return this.offset;
        }

        @Override
        public IterateByteOffsetNoZero clone() {
            return new IterateByteOffsetNoZero(this.index, this.offset);
        }

        @Override
        public int getDataIndex() {
            return this.index;
        }

        @Override
        public int getOffsetsIndex() {
            return this.index;
        }
    }
}

