/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.AutomatedInstallScriptFilter;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class FinishPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257282535107998009L;
    protected JButton autoButton;
    protected VariableSubstitutor vs;

    public FinishPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, new GridBagLayout());
        this.vs = new VariableSubstitutor(installData.getVariables());
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.parent.langpack.getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 4;
        if (this.idata.installSuccess) {
            JLabel jLabel = LabelFactory.create(this.idata.langpack.getString("FinishPanel.success"), this.parent.icons.getImageIcon("preferences"), 10);
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridx = 0;
            IzPanel.Filler filler = new IzPanel.Filler();
            this.add((Component)filler, gridBagConstraints);
            this.add((Component)jLabel, gridBagConstraints);
            if (this.idata.uninstallOutJar != null) {
                String string = this.translatePath(this.idata.info.getUninstallerPath());
                gridBagConstraints.gridx = 0;
                this.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.uninst.info"), this.parent.icons.getImageIcon("preferences"), 10), gridBagConstraints);
                gridBagConstraints.gridx = 0;
                this.add((Component)LabelFactory.create("  " + string, this.parent.icons.getImageIcon("empty"), 10), gridBagConstraints);
            }
            this.autoButton = ButtonFactory.createButton(this.parent.langpack.getString("FinishPanel.auto"), this.parent.icons.getImageIcon("edit"), this.idata.buttonsHColor);
            this.autoButton.setToolTipText(this.parent.langpack.getString("FinishPanel.auto.tip"));
            this.autoButton.addActionListener(this);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(40, 0, 0, 0);
            gridBagConstraints.gridx = 0;
            this.add((Component)this.autoButton, gridBagConstraints);
        } else {
            this.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.fail"), this.parent.icons.getImageIcon("stop"), 10), "nextLine");
            ++gridBagConstraints.gridy;
        }
        this.getLayoutHelper().completeLayout();
        Log.getInstance().informUser();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(this.idata.getInstallPath()));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new AutomatedInstallScriptFilter());
        try {
            if (jFileChooser.showSaveDialog(this) == 0) {
                File file = jFileChooser.getSelectedFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 5120);
                this.parent.writeXMLTree(this.idata.xmlData, bufferedOutputStream);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                this.autoButton.setEnabled(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, exception.toString(), this.parent.langpack.getString("installer.error"), 0);
        }
    }

    protected String translatePath(String string) {
        string = this.vs.substitute(string, null);
        return string.replace('/', File.separatorChar);
    }
}

